/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.fabric;

import com.agricraft.agricraft.AgriCraft;
import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CompatConfig;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.common.commands.DumpRegistriesCommand;
import com.agricraft.agricraft.common.commands.GiveSeedCommand;
import com.agricraft.agricraft.common.handler.DenyBonemeal;
import com.agricraft.agricraft.common.handler.VanillaSeedConversion;
import com.agricraft.agricraft.common.plugin.BotaniaFabricPlugin;
import com.agricraft.agricraft.common.plugin.FabricSeasonPlugin;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.common.util.fabric.FabricPlatform;
import com.agricraft.agricraft.compat.botania.ManaGrowthCondition;
import com.agricraft.agricraft.plugin.minecraft.MinecraftPlugin;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1269;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaNetworkCallback;

public class AgriCraftFabric
implements ModInitializer {
    public static MinecraftServer cachedServer;

    public void onInitialize() {
        Platform.setup(new FabricPlatform());
        AgriCraft.init();
        DynamicRegistries.registerSynced(AgriApi.AGRIPLANTS, AgriPlant.CODEC, AgriPlant.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(AgriApi.AGRIWEEDS, AgriWeed.CODEC, AgriWeed.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(AgriApi.AGRISOILS, AgriSoil.CODEC, AgriSoil.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(AgriApi.AGRIMUTATIONS, AgriMutation.CODEC, AgriMutation.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(AgriApi.AGRIFERTILIZERS, AgriFertilizer.CODEC, AgriFertilizer.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            cachedServer = server;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            GiveSeedCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            DumpRegistriesCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> VanillaSeedConversion.onRightClick(player, hand, hitResult.method_17777(), hitResult));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (DenyBonemeal.denyBonemeal(player, hand, hitResult.method_17777(), world)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        MinecraftPlugin.init();
        FabricSeasonPlugin.init();
        FabricLoader.getInstance().getModContainer("agricraft").ifPresent(agricraft -> {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                String modid = mod.getMetadata().getId();
                if (modid.equals("agricraft") || modid.equals("minecraft")) continue;
                if (agricraft.findPath("datapacks/" + modid).isPresent()) {
                    ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("builtin", "agricraft_datapacks_" + modid), (String)("datapacks/" + modid), (ModContainer)agricraft, (boolean)CoreConfig.enablePacksByDefault);
                }
                if (!agricraft.findPath("resourcepacks/" + modid).isPresent()) continue;
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("builtin", "agricraft_resourcepacks_" + modid), (String)("resourcepacks/" + modid), (ModContainer)agricraft, (boolean)CoreConfig.enablePacksByDefault);
            }
        });
        if (FabricLoader.getInstance().isModLoaded("botania") && CompatConfig.enableBotania) {
            BotaniaFabricPlugin.init();
            ManaNetworkCallback.EVENT.register((manaReceiver, manaBlockType, manaNetworkAction) -> {
                if (manaNetworkAction == ManaNetworkAction.REMOVE && manaBlockType == ManaBlockType.POOL) {
                    ManaGrowthCondition.removePoll(manaReceiver);
                }
            });
        }
    }
}

